;; This example shows how to format a track to 
;; DATA format
;;
;; This code is public domain and can be used in your
;; own programs.
;; 
;; Written by Kevin Thacker, 2002.
;;
;;------------------------------------------------

;; firmware function to find a RSX
.kl_find_command equ &bcd4

org &8000
nolist

;;------------------------------------------------
;; find BIOS: FORMAT TRACK command
;;
;; This method is compatible with other DOSs that
;; override or provide this command. If the command
;; is not found, then there is no furthur action. Therefore
;; on tape based systems, this code will have no effect.

ld hl,cmd_bios_format_track
call kl_find_command
ret nc

;; command found

;; store address of command
ld (bios_format_track),hl

;; store "rom select" of command
ld a,c
ld (bios_format_track+2),a

;;------------------------------------------------------------------

;; D = track number
;; (change this value to define the track to write to )
ld d,0

;; HL = address of C,H,R,N table 
ld hl,sectorIDs
;; number of sectors defined in table
ld b,9
.setup_track
;; write D value into C parameter of each sector
ld (hl),d
;; go to next C,H,R,N entry in table
inc hl
inc hl
inc hl
inc hl
djnz setup_track

;; E = drive number (0 or 1)
;; (change this value to define the disc drive to write to)
ld e,0

;; execute command
rst 3
defw bios_format_track

ret

;;------------------------------------------------------------------

;; this is initialised when the "BIOS: FORMAT TRACK" RSX has been found.
.bios_format_track
defw 0                    ;; address of function
defb 0                    ;; "rom select" for function


.cmd_bios_format_track
defb 6+&80				;; this is the "BIOS: FORMAT TRACK" RSX


;;------------------------------------------------------------------

.sectorIDs
;; C, H, R, N
;; N = 2 defines a sector size of 512 bytes
;; R defines id of each sector
;; H = 0 for DATA format
;; C will be setup to be the number of the track
defb &0, &0, &c1,&2
defb &0, &0, &c6,&2
defb &0, &0, &c2,&2
defb &0, &0, &c7,&2
defb &0, &0, &c3,&2
defb &0, &0, &c8,&2
defb &0, &0, &c4,&2
defb &0, &0, &c9,&2
defb &0, &0, &c5,&2
